/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore;

import java.util.concurrent.atomic.AtomicInteger;
import net.szum123321.textile_backup.TextileLogger;

public class AwaitThread
extends Thread {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final AtomicInteger threadCounter = new AtomicInteger(0);
    private final int delay;
    private final int thisThreadId = threadCounter.getAndIncrement();
    private final Runnable taskRunnable;

    public AwaitThread(int delay, Runnable taskRunnable) {
        this.setName("Textile Backup await thread nr. " + this.thisThreadId);
        this.delay = delay;
        this.taskRunnable = taskRunnable;
    }

    @Override
    public void run() {
        log.info("Countdown begins... Waiting {} second.", this.delay);
        try {
            Thread.sleep((long)this.delay * 1000L);
        }
        catch (InterruptedException e) {
            log.info("Backup restoration cancelled.", new Object[0]);
            return;
        }
        new Thread(this.taskRunnable, "Textile Backup restore thread nr. " + this.thisThreadId).start();
    }
}

