/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.config.ConfigPOJO;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.CompressionStatus;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.ExecutableBackup;
import net.szum123321.textile_backup.core.restore.RestoreContext;
import net.szum123321.textile_backup.core.restore.decompressors.GenericTarDecompressor;
import net.szum123321.textile_backup.core.restore.decompressors.ZipDecompressor;
import net.szum123321.textile_backup.mixin.MinecraftServerSessionAccessor;

public class RestoreBackupRunnable
implements Runnable {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private final RestoreContext ctx;

    public RestoreBackupRunnable(RestoreContext ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Path tmp;
        Globals.INSTANCE.globalShutdownBackupFlag.set(false);
        log.info("Shutting down server...", new Object[0]);
        this.ctx.server().method_3747(false);
        Path worldFile = Utilities.getWorldFolder(this.ctx.server());
        try {
            tmp = Files.createTempDirectory(this.ctx.server().method_3831().toPath(), this.ctx.restoreableFile().getFile().getFileName().toString(), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("An exception occurred while unpacking backup", new Object[]{e});
            return;
        }
        FutureTask<Void> waitForShutdown = new FutureTask<Void>(() -> {
            this.ctx.server().method_3777().join();
            if (RestoreBackupRunnable.config.get().backupOldWorlds) {
                return ExecutableBackup.Builder.newBackupContextBuilder().setServer(this.ctx.server()).setInitiator(ActionInitiator.Restore).noCleanup().setComment("Old_World" + (String)(this.ctx.comment() != null ? "_" + this.ctx.comment() : "")).announce().build().call();
            }
            return null;
        });
        new Thread(waitForShutdown, "Server shutdown wait thread").start();
        try {
            Optional<String> errorMsg;
            log.info("Starting decompression...", new Object[0]);
            long hash = this.ctx.restoreableFile().getArchiveFormat() == ConfigPOJO.ArchiveFormat.ZIP ? ZipDecompressor.decompress(this.ctx.restoreableFile().getFile(), tmp) : GenericTarDecompressor.decompress(this.ctx.restoreableFile().getFile(), tmp);
            log.info("Waiting for server to fully terminate...", new Object[0]);
            waitForShutdown.get();
            if (Files.notExists(CompressionStatus.resolveStatusFilename(tmp), new LinkOption[0])) {
                errorMsg = Optional.of("Status file not found!");
            } else {
                CompressionStatus status = CompressionStatus.readFromFile(tmp);
                log.info("Status: {}", status);
                Files.delete(tmp.resolve("textile_status.data"));
                errorMsg = status.validate(hash, this.ctx);
            }
            if (errorMsg.isEmpty() || !RestoreBackupRunnable.config.get().integrityVerificationMode.verify()) {
                if (errorMsg.isEmpty()) {
                    log.info("Backup valid. Restoring", new Object[0]);
                } else {
                    log.info("Backup is damaged, but verification is disabled [{}]. Restoring", errorMsg.get());
                }
                ((MinecraftServerSessionAccessor)this.ctx.server()).getSession().close();
                Utilities.deleteDirectory(worldFile);
                Files.move(tmp, worldFile, new CopyOption[0]);
                if (RestoreBackupRunnable.config.get().deleteOldBackupAfterRestore) {
                    log.info("Deleting restored backup file", new Object[0]);
                    Files.delete(this.ctx.restoreableFile().getFile());
                }
            } else {
                log.error(errorMsg.get(), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("An exception occurred while trying to restore a backup!", new Object[]{e});
        }
        finally {
            if (Files.exists(tmp, new LinkOption[0])) {
                try {
                    Utilities.deleteDirectory(tmp);
                }
                catch (IOException iOException) {}
            }
        }
        Globals.INSTANCE.globalShutdownBackupFlag.set(true);
        log.info("Done!", new Object[0]);
    }
}

