/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore.decompressors;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.digest.FileTreeHashBuilder;
import net.szum123321.textile_backup.core.digest.HashingOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;

public class GenericTarDecompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long decompress(Path input, Path target) throws IOException {
        Instant start = Instant.now();
        FileTreeHashBuilder treeBuilder = new FileTreeHashBuilder(0);
        try (InputStream fileInputStream = Files.newInputStream(input, new OpenOption[0]);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
             InputStream compressorInputStream = GenericTarDecompressor.getCompressorInputStream(bufferedInputStream);
             TarArchiveInputStream archiveInputStream = new TarArchiveInputStream(compressorInputStream);){
            TarArchiveEntry entry;
            while ((entry = archiveInputStream.getNextTarEntry()) != null) {
                if (!archiveInputStream.canReadEntryData((ArchiveEntry)entry)) {
                    throw new IOException("Couldn't read archive entry! " + entry.getName());
                }
                Path file = target.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
                try (HashingOutputStream out = new HashingOutputStream(outputStream, file, treeBuilder);){
                    IOUtils.copy((InputStream)archiveInputStream, (OutputStream)out);
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
        log.info("Decompression took {} seconds.", Utilities.formatDuration(Duration.between(start, Instant.now())));
        try {
            return treeBuilder.getValue(false);
        }
        catch (InterruptedException ignored) {
            return 0L;
        }
    }

    private static InputStream getCompressorInputStream(InputStream inputStream) throws CompressorException {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(inputStream);
        }
        catch (CompressorException e) {
            int signatureLength;
            byte[] tarHeader = new byte[512];
            inputStream.mark(tarHeader.length);
            try {
                signatureLength = IOUtils.readFully((InputStream)inputStream, (byte[])tarHeader);
                inputStream.reset();
            }
            catch (IOException e1) {
                throw new CompressorException("IOException while reading tar signature", (Throwable)e1);
            }
            if (TarArchiveInputStream.matches((byte[])tarHeader, (int)signatureLength)) {
                return inputStream;
            }
            throw e;
        }
    }
}

