/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.support.lang.At4JException;

public class BZip2OutputStreamSettings
implements Cloneable {
    public static final int MIN_BLOCK_SIZE = 1;
    public static final int MAX_BLOCK_SIZE = 9;
    public static final int DEFAULT_BLOCK_SIZE = 9;
    public static final int DEFAULT_NO_OF_HUFFMAN_TREE_REFINEMENT_ITERATIONS = 5;
    public static final int DEFAULT_NO_OF_ENCODER_THREADS = 0;
    private int m_blockSize = 9;
    private int m_numberOfHuffmanTreeRefinementIterations = 5;
    private int m_numberOfEncoderThreads = 0;
    private BZip2EncoderExecutorService m_executorService;

    public BZip2OutputStreamSettings setBlockSize(int bs) throws IllegalArgumentException {
        if (bs < 1 || bs > 9) {
            throw new IllegalArgumentException("Invalid block size " + bs + ". It must be between 1 and 9 (inclusive)");
        }
        this.m_blockSize = bs;
        return this;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    public BZip2OutputStreamSettings setNumberOfHuffmanTreeRefinementIterations(int no) throws IllegalArgumentException {
        if (no < 1) {
            throw new IllegalArgumentException("Invalid value " + no + ". It must be greater than zero");
        }
        this.m_numberOfHuffmanTreeRefinementIterations = no;
        return this;
    }

    public int getNumberOfHuffmanTreeRefinementIterations() {
        return this.m_numberOfHuffmanTreeRefinementIterations;
    }

    public BZip2OutputStreamSettings setLogAdapter(Object la) {
        return this;
    }

    public BZip2OutputStreamSettings setNumberOfEncoderThreads(int no) throws IllegalArgumentException {
        if (no < 0) {
            throw new IllegalArgumentException("Invalid number of encoder threads " + no + ". The number must be zero or greater");
        }
        this.m_numberOfEncoderThreads = no;
        return this;
    }

    public int getNumberOfEncoderThreads() {
        return this.m_numberOfEncoderThreads;
    }

    public BZip2OutputStreamSettings setExecutorService(BZip2EncoderExecutorService executorService) {
        this.m_executorService = executorService;
        return this;
    }

    public BZip2EncoderExecutorService getExecutorService() {
        return this.m_executorService;
    }

    public BZip2OutputStreamSettings clone() {
        try {
            return (BZip2OutputStreamSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new At4JException("Bug", e);
        }
    }
}

