/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.comp.bzip2.ThreeWayRadixQuicksort;

final class BurrowsWheelerEncoder {
    private static int MIN_QUICKSORT_LENGTH = 18;
    private final byte[] m_data;
    private final int m_length;
    private final EncodingScratchpad m_scratchpad;

    BurrowsWheelerEncoder(byte[] data, int length, EncodingScratchpad sp) {
        if (length > data.length) {
            throw new IllegalArgumentException("Invalid data length " + length + ". It must be <= the length of the data array (" + data.length + ")");
        }
        this.m_data = data;
        this.m_length = length;
        this.m_scratchpad = sp;
    }

    BurrowsWheelerEncodingResult encode() {
        int[] ptr = new ThreeWayRadixQuicksort(this.m_data, this.m_length, MIN_QUICKSORT_LENGTH, this.m_scratchpad).sort();
        byte[] lastColumn = this.m_scratchpad.m_lastColumn;
        int firstRow = -1;
        for (int i = 0; i < this.m_length; ++i) {
            int fePtr = ptr[i] - 1;
            if (fePtr < 0) {
                fePtr += this.m_length;
                firstRow = i;
            }
            lastColumn[i] = this.m_data[fePtr];
        }
        return new BurrowsWheelerEncodingResult(lastColumn, firstRow);
    }

    static class BurrowsWheelerEncodingResult {
        final byte[] m_lastColumn;
        final int m_firstPointer;

        private BurrowsWheelerEncodingResult(byte[] lastColumn, int firstPointer) {
            this.m_lastColumn = lastColumn;
            this.m_firstPointer = firstPointer;
        }
    }
}

