/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.at4j.comp.bzip2.EncodedBlockData;
import org.at4j.support.io.BitOutput;

final class EncodedBlockWriter {
    private final BitOutput m_out;
    private final Map<Integer, EncodedBlockData> m_savedBlocks = new HashMap<Integer, EncodedBlockData>();
    private final CountDownLatch m_doneLatch = new CountDownLatch(1);
    private int m_nextBlockToWrite = 0;
    private boolean m_hasError;

    EncodedBlockWriter(BitOutput out) {
        this.m_out = out;
    }

    private void writeEncodedBlockData(EncodedBlockData bd) throws IOException {
        this.m_out.writeBytes(bd.m_bytes, 0, bd.m_bytes.length);
        if (bd.m_noBits > 0) {
            this.m_out.writeBits(bd.m_bitValue, bd.m_noBits);
        }
    }

    private void writeBlockInternal(int blockNo, EncodedBlockData blockData) throws IOException {
        if (blockData == null) {
            this.m_doneLatch.countDown();
        } else {
            this.writeEncodedBlockData(blockData);
            while (this.m_savedBlocks.containsKey(++this.m_nextBlockToWrite)) {
                EncodedBlockData savedBd = this.m_savedBlocks.get(this.m_nextBlockToWrite);
                if (savedBd != null) {
                    this.writeEncodedBlockData(savedBd);
                    continue;
                }
                this.m_doneLatch.countDown();
                break;
            }
        }
    }

    private void saveBlock(int blockNo, EncodedBlockData blockData) {
        this.m_savedBlocks.put(blockNo, blockData);
    }

    synchronized void writeBlock(int blockNo, EncodedBlockData blockData) throws IOException {
        if (this.m_hasError) {
            return;
        }
        try {
            if (blockNo == this.m_nextBlockToWrite) {
                this.writeBlockInternal(blockNo, blockData);
            } else {
                this.saveBlock(blockNo, blockData);
            }
        }
        catch (IOException | Error | RuntimeException e) {
            this.m_hasError = true;
            this.m_doneLatch.countDown();
            throw e;
        }
    }

    void waitFor() throws InterruptedException {
        this.m_doneLatch.await();
    }
}

