/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.comp;

public class ByteMoveToFront {
    private final byte[] m_alphabet;

    private static byte[] createByteAlphabetFromRange(int minVal, int maxVal) throws IndexOutOfBoundsException {
        if (minVal < 0 || maxVal > 255 || minVal >= maxVal) {
            throw new IndexOutOfBoundsException("Invalid min and/or max value: min " + minVal + ", max " + maxVal);
        }
        int alphLen = maxVal - minVal + 1;
        byte[] alphabet = new byte[alphLen];
        for (int i = 0; i < alphLen; ++i) {
            alphabet[i] = (byte)(i + minVal & 0xFF);
        }
        return alphabet;
    }

    public ByteMoveToFront(int minValue, int maxValue) throws IndexOutOfBoundsException {
        this(ByteMoveToFront.createByteAlphabetFromRange(minValue, maxValue));
    }

    public ByteMoveToFront(byte[] alphabet) {
        alphabet.getClass();
        this.m_alphabet = alphabet;
    }

    public byte[] encode(byte[] in, byte[] out) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (out.length < in.length) {
            throw new IllegalArgumentException("The output array must be at least of the same length as the input array. Was in: " + in.length + ", out: " + out.length);
        }
        block0: for (int i = 0; i < in.length; ++i) {
            byte val = in[i];
            if (this.m_alphabet[0] == val) {
                out[i] = 0;
                continue;
            }
            byte prev = this.m_alphabet[0];
            int j = 1;
            while (true) {
                byte nextPrev = this.m_alphabet[j];
                if (this.m_alphabet[j] == val) {
                    out[i] = (byte)(j & 0xFF);
                    this.m_alphabet[0] = this.m_alphabet[j];
                    this.m_alphabet[j] = prev;
                    continue block0;
                }
                this.m_alphabet[j] = prev;
                prev = nextPrev;
                ++j;
            }
        }
        return out;
    }

    public byte decode(int index) {
        byte val = this.m_alphabet[index];
        System.arraycopy(this.m_alphabet, 0, this.m_alphabet, 1, index);
        this.m_alphabet[0] = val;
        return val;
    }

    public byte[] decode(byte[] in, byte[] out) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (out.length < in.length) {
            throw new IllegalArgumentException("The output array must be at least of the same length as the input array. Was in: " + in.length + ", out: " + out.length);
        }
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.decode(in[i]);
        }
        return out;
    }
}

