/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.comp;

public class IntMoveToFront {
    private final int[] m_alphabet;

    private static int[] createIntAlphabetFromRange(int minVal, int maxVal) throws IndexOutOfBoundsException {
        if (minVal >= maxVal) {
            throw new IndexOutOfBoundsException("Invalid min and max values. Min=" + minVal + ", max=" + maxVal);
        }
        int alphLen = maxVal - minVal + 1;
        int[] alphabet = new int[alphLen];
        for (int i = 0; i < alphLen; ++i) {
            alphabet[i] = i + minVal;
        }
        return alphabet;
    }

    public IntMoveToFront(int minValue, int maxValue) throws IndexOutOfBoundsException {
        this(IntMoveToFront.createIntAlphabetFromRange(minValue, maxValue));
    }

    public IntMoveToFront(int[] alphabet) {
        alphabet.getClass();
        this.m_alphabet = alphabet;
    }

    public int[] encode(int[] in, int[] out) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (out.length < in.length) {
            throw new IllegalArgumentException("The output array must be at least of the same length as the input array. Was in: " + in.length + ", out: " + out.length);
        }
        block0: for (int i = 0; i < in.length; ++i) {
            int val = in[i];
            if (this.m_alphabet[0] == val) {
                out[i] = 0;
                continue;
            }
            int prev = this.m_alphabet[0];
            int j = 1;
            while (true) {
                int nextPrev = this.m_alphabet[j];
                if (this.m_alphabet[j] == val) {
                    out[i] = (byte)(j & 0xFF);
                    this.m_alphabet[0] = this.m_alphabet[j];
                    this.m_alphabet[j] = prev;
                    continue block0;
                }
                this.m_alphabet[j] = prev;
                prev = nextPrev;
                ++j;
            }
        }
        return out;
    }

    public int decode(int index) {
        int val = this.m_alphabet[index];
        System.arraycopy(this.m_alphabet, 0, this.m_alphabet, 1, index);
        this.m_alphabet[0] = val;
        return val;
    }

    public int[] decode(int[] in, int[] out) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (out.length < in.length) {
            throw new IllegalArgumentException("The output array must be at least of the same length as the input array. Was in: " + in.length + ", out: " + out.length);
        }
        for (int i = 0; i < in.length; ++i) {
            int index = in[i];
            int val = this.m_alphabet[index];
            System.arraycopy(this.m_alphabet, 0, this.m_alphabet, 1, index);
            this.m_alphabet[0] = val;
            out[i] = val;
        }
        return out;
    }
}

