/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.io;

import java.io.IOException;
import java.io.OutputStream;
import org.at4j.support.io.BitOutput;

public class LittleEndianBitOutputStream
extends OutputStream
implements BitOutput {
    private static final int POINTER_START_OF_BYTE = 0;
    private static final int POINTER_END_OF_BYTE = 7;
    private final OutputStream m_out;
    private int m_curByte = 0;
    private int m_pointerInByte = 0;
    private long m_numberOfBytesWritten = 0L;

    public LittleEndianBitOutputStream(OutputStream wrapped) {
        wrapped.getClass();
        this.m_out = wrapped;
    }

    private boolean isAtByteBoundary() {
        return this.m_pointerInByte == 0;
    }

    private void assertAtByteBoundary() throws IOException {
        if (!this.isAtByteBoundary()) {
            this.throwIOException("Not at byte boundary. Position: pos=" + this.m_pointerInByte);
        }
    }

    private void throwIOException(String msg) throws IOException {
        throw new IOException(msg + ". Position in stream: " + this.m_numberOfBytesWritten);
    }

    private void writeCurByte() throws IOException {
        this.m_out.write(this.m_curByte);
        ++this.m_numberOfBytesWritten;
        this.m_pointerInByte = 0;
        this.m_curByte = 0;
    }

    public long getNumberOfBytesWritten() {
        return this.m_numberOfBytesWritten;
    }

    @Override
    public int getUnfinishedByte() {
        return this.m_pointerInByte > 0 ? this.m_curByte >>> 7 - (this.m_pointerInByte - 1) : 0;
    }

    @Override
    public int getNumberOfBitsInUnfinishedByte() {
        return this.m_pointerInByte;
    }

    @Override
    public void padToByteBoundary() throws IOException {
        if (this.m_pointerInByte > 0) {
            this.writeCurByte();
        }
    }

    @Override
    public void writeBit(boolean val) throws IOException {
        if (val) {
            this.m_curByte |= 1 << 7 - this.m_pointerInByte;
        }
        ++this.m_pointerInByte;
        if (this.m_pointerInByte > 7) {
            this.writeCurByte();
        }
    }

    @Override
    public void writeBits(int val, int no) throws IOException, IndexOutOfBoundsException {
        if (no < 0 || no > 8) {
            throw new IndexOutOfBoundsException("Invalid number of bits " + no + ". Must be between 0 and 8 (inclusive)");
        }
        if (no == 0) {
            return;
        }
        if (this.m_pointerInByte + no <= 8) {
            this.m_curByte |= (val & (1 << no) - 1) << 8 - this.m_pointerInByte - no;
            this.m_pointerInByte += no;
            if (this.m_pointerInByte > 7) {
                this.writeCurByte();
            }
        } else {
            int bitsToWriteInCurByte = 8 - this.m_pointerInByte;
            int bitsToWriteInNextByte = no - bitsToWriteInCurByte;
            this.m_curByte |= val >>> no - bitsToWriteInCurByte;
            this.writeCurByte();
            this.m_curByte = (val & (1 << bitsToWriteInNextByte) - 1) << 8 - bitsToWriteInNextByte;
            this.m_pointerInByte = bitsToWriteInNextByte;
        }
    }

    @Override
    public void writeBitsLittleEndian(int val, int no) throws IndexOutOfBoundsException, IOException {
        if (no < 0 || no > 32) {
            throw new IndexOutOfBoundsException("Invalid number of bits to write " + no + ". It must be between 0 and 32 (inclusive)");
        }
        if (no == 0) {
            return;
        }
        int noWrites = no / 8;
        int mod = no % 8;
        if (mod != 0) {
            this.writeBits(val >>> noWrites * 8, mod);
        }
        for (int i = 0; i < noWrites; ++i) {
            this.writeBits(val >>> (noWrites - i - 1) * 8, 8);
        }
    }

    @Override
    public void writeBytes(byte[] barr, int off, int len) throws IndexOutOfBoundsException, IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("Invalid offset " + off + ". It must be >= 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length " + len + ". It must be >= 0");
        }
        if (off + len > barr.length) {
            throw new IndexOutOfBoundsException("Invalid offset + length (" + off + " + " + len + "). It must be <= the length of the supplied array (" + barr.length + ")");
        }
        if (len == 0) {
            return;
        }
        if (this.isAtByteBoundary()) {
            this.m_out.write(barr, off, len);
            this.m_numberOfBytesWritten += (long)len;
        } else {
            byte[] toWrite = new byte[len];
            System.arraycopy(barr, off, toWrite, 0, len);
            int prevByte = this.m_curByte;
            int leftShiftDistance = 8 - this.m_pointerInByte;
            for (int i = 0; i < len; ++i) {
                int nextPrevByte = (toWrite[i] & 0xFF) << leftShiftDistance;
                toWrite[i] = (byte)((prevByte | (toWrite[i] & 0xFF) >>> this.m_pointerInByte) & 0xFF);
                prevByte = nextPrevByte;
            }
            this.m_curByte = prevByte & 0xFF;
            this.m_out.write(toWrite);
            this.m_numberOfBytesWritten += (long)len;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.assertAtByteBoundary();
        this.m_out.write(b);
        ++this.m_numberOfBytesWritten;
    }

    @Override
    public void write(byte[] barr) throws IOException {
        this.write(barr, 0, barr.length);
    }

    @Override
    public void write(byte[] barr, int off, int len) throws IOException {
        this.assertAtByteBoundary();
        this.m_out.write(barr, off, len);
        this.m_numberOfBytesWritten += (long)len;
    }

    @Override
    public void close() throws IOException {
        this.m_out.close();
        super.close();
    }
}

