/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.Serializable;

public final class UnsignedShort
implements Serializable,
Comparable<UnsignedShort> {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 2;
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    public static final UnsignedShort ZERO = new UnsignedShort(0);
    public static final UnsignedShort ONE = new UnsignedShort(1);
    public static final UnsignedShort ONE_THOUSAND = new UnsignedShort(1000);
    private final short m_value;

    private UnsignedShort(short value) {
        this.m_value = value;
    }

    public static UnsignedShort valueOf(short value) {
        switch (value) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 1000: {
                return ONE_THOUSAND;
            }
        }
        return new UnsignedShort(value);
    }

    public static UnsignedShort valueOf(int value) throws IllegalArgumentException {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Illegal unsigned short value " + value + ". It must be between 0 and 65535 (inclusive)");
        }
        return UnsignedShort.valueOf((short)(value & 0xFFFF));
    }

    public int intValue() {
        return this.m_value & 0xFFFF;
    }

    public byte[] getBigEndianByteArray() {
        byte[] res = new byte[]{(byte)(this.m_value & 0xFF), (byte)(this.m_value >>> 8 & 0xFF)};
        return res;
    }

    public static UnsignedShort fromBigEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 2) {
            throw new IllegalArgumentException("The supplied byte array must be two bytes long");
        }
        return UnsignedShort.fromBigEndianByteArray(barr, 0);
    }

    public static UnsignedShort fromBigEndianByteArray(byte[] barr, int offset) throws ArrayIndexOutOfBoundsException {
        return UnsignedShort.valueOf((short)((barr[offset] & 0xFF) + ((barr[offset + 1] & 0xFF) << 8) & 0xFFFF));
    }

    public boolean equals(Object o) {
        return o instanceof UnsignedShort && ((UnsignedShort)o).m_value == this.m_value;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(UnsignedShort s2) {
        return this.intValue() - s2.intValue();
    }

    public String toString() {
        return Integer.toString(this.m_value & 0xFFFF);
    }
}

