/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.registry;

import eu.pb4.graves.GravesMod;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.other.VisualGraveData;
import eu.pb4.graves.registry.AbstractGraveBlock;
import eu.pb4.graves.registry.GraveBlockEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends AbstractGraveBlock
implements class_2343 {
    public static GraveBlock INSTANCE = new GraveBlock();

    private GraveBlock() {
        super(class_4970.class_2251.method_9637().method_42327().method_22488().method_9624().method_9629(2.0f, 999.0f));
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        GraveBlockEntity be;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GraveBlockEntity && (be = (GraveBlockEntity)class_25862).getGrave().canTakeFrom(player)) {
            return super.method_9594(state, player, world, pos);
        }
        return -1.0f;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        GraveBlockEntity grave;
        class_2586 blockEntity;
        if (world.method_8503() == null) {
            return;
        }
        if (state.method_26204() != newState.method_26204() && (blockEntity = world.method_8321(pos)) instanceof GraveBlockEntity && (grave = (GraveBlockEntity)blockEntity).getGrave() != null) {
            grave.getGrave().destroyGrave(world.method_8503(), null);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 playerTemp) {
        GraveBlockEntity graveBlockEntity;
        if (!(playerTemp instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerTemp;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity && (graveBlockEntity = (GraveBlockEntity)blockEntity).getGrave() != null && graveBlockEntity.getGrave().canTakeFrom((class_1657)player)) {
            try {
                Grave grave = graveBlockEntity.getGrave();
                grave.destroyGrave(player.method_5682(), (class_1657)player);
                if (ConfigManager.getConfig().placement.restoreBlockAfterPlayerBreaking) {
                    graveBlockEntity.breakBlock();
                }
            }
            catch (Exception e) {
                GravesMod.LOGGER.error("Exception occurred while breaking grave!", (Throwable)e);
            }
        }
        super.method_9576(world, pos, state, (class_1657)player);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerTemp, class_1268 hand, class_3965 hit) {
        GraveBlockEntity graveBlockEntity;
        class_3222 player;
        block13: {
            block12: {
                if (!(playerTemp instanceof class_3222)) break block12;
                player = (class_3222)playerTemp;
                if (hand != class_1268.field_5810) break block13;
            }
            return playerTemp.method_5715() ? class_1269.field_5811 : class_1269.field_5814;
        }
        class_2586 blockEntity = world.method_8321(pos);
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && playerTemp.method_5715()) {
            return class_1269.field_5811;
        }
        if (blockEntity instanceof GraveBlockEntity && (graveBlockEntity = (GraveBlockEntity)blockEntity).getGrave() != null && graveBlockEntity.getGrave().hasAccess((class_1657)player)) {
            try {
                Grave grave = graveBlockEntity.getGrave();
                grave.updateSelf(world.method_8503());
                if (!grave.isRemoved()) {
                    if (ConfigManager.getConfig().interactions.shiftClickTakesItems && (player.method_5715() || !ConfigManager.getConfig().interactions.clickGraveToOpenGui)) {
                        grave.quickEquip(player);
                    } else if (!player.method_5715()) {
                        grave.openUi(player, true, false);
                    } else {
                        return class_1269.field_5811;
                    }
                }
                return class_1269.field_5812;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return class_1269.field_5812;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GraveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return type == GraveBlockEntity.BLOCK_ENTITY_TYPE && !world.field_9236 ? GraveBlockEntity::tick : null;
    }

    @Override
    @Nullable
    protected Grave getGraveData(class_1937 world, class_2338 pos) {
        Optional entity = world.method_35230(pos, GraveBlockEntity.BLOCK_ENTITY_TYPE);
        return entity.isPresent() ? ((GraveBlockEntity)entity.get()).getGrave() : null;
    }

    @Override
    protected VisualGraveData getVisualData(class_1937 world, class_2338 pos, @Nullable Grave grave) {
        return grave != null ? grave.toVisualGraveData() : VisualGraveData.DEFAULT;
    }

    @Override
    protected Map<String, class_2561> getPlaceholders(MinecraftServer server, VisualGraveData visualGrave, @Nullable Grave grave) {
        return grave != null ? grave.getPlaceholders(server) : visualGrave.getPlaceholders(server);
    }
}

