/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reputation.provider;

import atonkish.reputation.util.ReputationStatus;
import atonkish.reputation.util.cache.VillagerCache;
import com.google.common.cache.Cache;
import java.util.Optional;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public enum VillagerReputationProvider implements IEntityComponentProvider,
IDataProvider<class_1646>
{
    INSTANCE;

    public static final String REPUTATION_KEY = "ReputationModReputation";

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getData().raw();
        class_1657 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getEntity();
        VillagerCache.Data villagerData = VillagerReputationProvider.getVillagerData(data, player, villager);
        @Nullable Integer reputation = villagerData.getReputation();
        ReputationStatus status = ReputationStatus.getStatus(reputation);
        class_5250 text = class_2561.method_43471((String)status.getTranslateKey());
        if (reputation != null) {
            text = text.method_27693(String.format(" (%d)", reputation));
        }
        text = text.method_27692(status.getFormatting());
        tooltip.addLine((class_2561)text);
    }

    public final void appendData(IDataWriter data, IServerAccessor<class_1646> accessor, IPluginConfig config) {
        class_3222 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getTarget();
        int reputation = villager.method_20594((class_1657)player);
        data.raw().method_10569(REPUTATION_KEY, reputation);
    }

    private static VillagerCache.Data getVillagerData(class_2487 data, class_1657 player, class_1646 villager) {
        Integer reputation;
        Cache<class_1646, VillagerCache.Data> villagerCache = VillagerCache.getOrCreate(player);
        VillagerCache.Data villagerData = Optional.ofNullable((VillagerCache.Data)villagerCache.getIfPresent((Object)villager)).orElse(new VillagerCache.Data());
        Integer n = reputation = data.method_10545(REPUTATION_KEY) ? Integer.valueOf(data.method_10550(REPUTATION_KEY)) : null;
        if (reputation != null) {
            villagerData.setReputation(reputation);
        }
        villagerCache.put((Object)villager, (Object)villagerData);
        return villagerData;
    }
}

